
#include "fp.h"
#include "matfp.hpp"
#include "matfpMath.hpp"
#include "matfpConv.hpp"
#include "matq.h"
#include "matqConv.h"
#include "matqMath.h"
#include "bf.h"
#include "matc.hpp"
#include "matcConv.hpp"
#include "matcMath.hpp"
#include "poly.h"
#include "polyConv.h"
#include "polyMath.h"
#include "polyFactor.h"
#include "mbMod.h"

using namespace std;

// https://en.wikipedia.org/wiki/Factorization_of_polynomials_over_finite_fields#Square-free_factorization

int main (int argc, char * const argv[])
{
    int     i, j, k, nr, nc;
    double  p;
    int     m;
    bf      det;
    matq    z, zt, ztInv, I, testI;
    bool    isGroup, isI;
    mb      pmb, kmb;
    
again:
    p = 0;
    while(p<2 || !isItPrime(p, 35))
    {
        cout << "p: ";
        cin >> p;
    }
    //cin.ignore();  // needed for next cin with prompt to behave
    
    m = 0;
    while(m<1)
    {
        cout << "m: ";
        cin >> m;
    }
    
    I = matqUnit(m);
    k = pow(p, m) - 1; // want a^k = I
    
    cout << "k = " << pow(p, m)-1 << endl << endl;
    
    equate(pmb, p);
    isGroup = false;
    while(!isGroup)
    {
        equate(kmb, k);
        zt = I;
        det = 0;
        while(!det.num)
        {
            myFree(zt);
            genRandIntMatOverp(zt, m, m, p);
            matqInvertModp(ztInv, det, zt, p);
            myFree(ztInv);
        }
        // zt is candidate
        if(zt==I)
            continue;
        // check if zt^k = I mod p
        // bool powerMod(matq& z, const matq& x, const mb& y, const mb& q); z = x^y mod p
        //cout << "zt = " << zt << endl;
        powerMod(testI, zt, kmb, pmb);
        //cout << "testI = " << testI << endl << endl;
        if(!(testI==I))
        {
            myFree(testI);
            continue;
        }
        //cout << "zt = " << zt << endl;
        // have possible seed matrix zt
        // now want to check for i=2, 3, ... k/2 & if i | k whether zt^i = I mod p, if so start over with new zt
        isI = false;
        for(i=2;i<=k/2;++i)
        {
            if(i*(k/i)==k)
            {
                myFree(testI);
                equate(kmb, i);
                powerMod(testI, zt, kmb, pmb);
                if(testI==I)
                {
                    isI = true;
                    break;
                }
            }
        }
        if(isI)
            continue;
        isGroup = true;
    }
    
    cout << "seed =" << endl;
    cout << zt << endl << endl;
    
    goto again;
    
    return 0;
}
 /*
 clock_t start, end;
 double elapsed;
 
 start = clock();

end = clock();
elapsed = ((double) (end - start)) / CLOCKS_PER_SEC;
 */
